#pragma once

// CElement command target

class CElement : public CObject
{
   protected:
      COLORREF m_Color;                  // Kolor elementu
      CRect m_EnclosingRect;             // Prostokt opisujcy element
      int m_Pen;                         // Szeoko pira

   public:
      virtual ~CElement();               // Wirtualny destruktor
      virtual void Draw(CDC* pDC) {}     // Wirtualna operacja rysowania

      CRect GetBoundRect();       // Pobierz prostokt ograniczajcy element

   protected:
      CElement();                        // Umieszczamy tutaj, aby zapobiec wywoaniu
};

class CLine :
  public CElement
{
   public:
      ~CLine(void);
      virtual void Draw(CDC* pDC);     // Funkcja wywietlajca lini

      // Konstruktor obiektu linii
      CLine(CPoint Start, CPoint End, COLORREF aColor);

   protected:
      CPoint m_StartPoint;             // Punkt pocztkowy linii
      CPoint m_EndPoint;               // Punkt kocowy linii

      CLine(void);                     // Domylny konstruktor - nie powinien by uywany
};

class CRectangle :
  public CElement
{
   public:
      ~CRectangle(void);
      virtual void Draw(CDC* pDC);     // Function to display a rectangle

      // Konstruktor obiektu prostokta
      CRectangle(CPoint Start, CPoint End, COLORREF aColor);

   protected:
      CRectangle(void);                // Domylny konstruktor - nie powinien by uywany
};

class CCircle :
  public CElement
{
   public:
      ~CCircle(void);
      virtual void Draw(CDC* pDC);     // Function to display a circle

      // Konstruktor obiektu okrgu
      CCircle(CPoint Start, CPoint End, COLORREF aColor);

   protected:
      CCircle(void);                   // Domylny konstruktor - nie powinien by uywany
};

class CCurve :
  public CElement
{
   public:
      ~CCurve(void);
      virtual void Draw(CDC* pDC); // Function to display a curve

      // Konstruktor obiektu krzywej
      CCurve(COLORREF aColor);

   protected:
      CCurve(void);                    // Domylny konstruktor - nie powinien by uywany
};


